package org.eclipse.atf.runtime;


public interface IRuntimeContainer {
	
	/**
	 * Returns an array of all the configured IRuntime.
	 * @return
	 */
	IRuntime[] getRuntimes();
	
	/**
	 * Gets the IRuntime instance with the specified type id.
	 * 
	 * @param type fully qualified id of the IRuntime instance
	 * @return
	 */
	IRuntime getRuntime( String type );
	
	/**
	 * Adds a runtime to the list of supported IRuntimes
	 * 
	 * @param runtime
	 */
	void addRuntime( IRuntime runtime );
	
	/**
	 * Removes a runtime from the list of supported IRuntimes
	 * @param runtime
	 */
	void removeRuntime( IRuntime runtime );
	
}
