package org.eclipse.atf.runtime;

public interface IRuntimeInstanceContainer {

	/**
	 * Returns an array with all the IRuntimeInstances found
	 * @return
	 */
	IRuntimeInstance [] getRuntimeInstances();
	
	/**
	 * Returns an array of IRuntimeInstance that have that IRuntime
	 * parameter as the type;
	 * 
	 * @param runtime instance of IRuntime
	 * @return
	 */
	IRuntimeInstance [] getRuntimeInstancesOfType( IRuntime runtime );
	
	/**
	 * Returns an array of IRuntimeInstance that are of the type specified by
	 * the input string.
	 * 
	 * @param type - fully qualified ID of an IRuntime instance
	 * @return
	 */
	IRuntimeInstance [] getRuntimeInstancesOfType( String type );
	
	/**
	 * Adds the IRuntimeInstance to the list of configured instances
	 * 
	 * @param instance
	 * @param type TODO
	 */
	void addRuntimeInstance( IRuntimeInstance instance, String type );


	/**
	 * Remove the IRuntimeInstance from the list of configured instances
	 * 
	 * @param instance
	 */
	void removeRuntimeInstance( IRuntimeInstance instance );
}
