package org.eclipse.atf.runtime;



public class RuntimeInstance implements IRuntimeInstance {

	/*
	 * Runtime that this is an instance of
	 */
	protected IRuntime type = null;
	
	/*
	 * Display name for the RuntimeInstance
	 */
	protected String name = null;
	
	/*
	 * version string
	 */
	protected String version = null;
	
	/*
	 * Location URL of the instance. It could be an eclipse URL which would
	 * point to a plugin stored instance, or it could be a file URL that points
	 * to a location in the file system set by the end-user.
	 */
	protected String location = null;
	
	/*
	 * Mark as a user defined instance
	 */
	protected boolean isUser = false;


	/* (non-Javadoc)
	 * @see org.eclipse.atf.runtime.IRuntimeInstance#getLocation()
	 */
	public String getLocation() {
		return location;
	}

	public void setLocation(String location) {
		this.location = location;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.atf.runtime.IRuntimeInstance#getType()
	 */
	public IRuntime getType() {
		return type;
	}

	public void setType(IRuntime type) {
		this.type = type;
	}

	/* 
	 * @see org.eclipse.atf.runtime.IRuntimeInstance#getVersion()
	 */
	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.atf.runtime.IRuntimeInstance#getName()
	 */
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.atf.runtime.IRuntimeInstance#isUser()
	 */
	public boolean isUser() {
		return isUser;
	}

	public void setIsUser(boolean isUser) {
		this.isUser = isUser;
	}
}
