package org.eclipse.atf.runtime.adapter;

import org.eclipse.atf.core.CorePlugin;
import org.eclipse.atf.runtime.IRuntime;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

/*
 * This adapter installs the runtime using Facets. This supports Faceted Projects such as
 * Static Web Project and Dynamic Web Project.
 */
public class FacetAwareRuntimeInstallerAdapter extends BaseRuntimeInstallerAdapter {

	public IStatus installRuntime(IRuntime runtime) {

		IStatus status = new Status( Status.OK, CorePlugin.PLUGIN_ID, Status.OK, "Install Success.", null );
		
		try{
			IFacetedProject fProject = ProjectFacetsManager.create(getProject());
			IProjectFacet facet = ProjectFacetsManager.getProjectFacet( runtime.getId() );
			IProjectFacetVersion facetVersion = facet.getLatestVersion();
			
			//only install if the facet is not available
			if(!fProject.hasProjectFacet(facetVersion)) {
				status = facetVersion.getConstraint().check(fProject.getProjectFacets());
				if(status.getSeverity() == IStatus.OK) {
					fProject.installProjectFacet(facetVersion, null, null);
				} else if(status instanceof MultiStatus){
					status = new Status( Status.ERROR, CorePlugin.PLUGIN_ID, Status.OK, "Error adding facet for runtime <"+runtime.getId()+">: Prerequisite facet constraints were not satisfied", null );
				}
				
			}
		}catch( CoreException e ){
			status = new Status( Status.ERROR, CorePlugin.PLUGIN_ID, Status.OK, "Error adding facet for runtime <"+runtime.getId()+">", e );
		}
		
		
		return status;
	}

	public boolean isInstalled(IRuntime runtime) {
		try{
			IFacetedProject fProject = ProjectFacetsManager.create(getProject());
			IProjectFacet facet = ProjectFacetsManager.getProjectFacet( runtime.getId() );
			return fProject.hasProjectFacet( facet );				
		
		}catch( CoreException e ){
			e.printStackTrace();
			return false;
		}
	}

}
