package org.eclipse.atf.runtime.adapter;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.wst.common.project.facet.core.internal.FacetedProjectNature;

public class RuntimeInstallerAdapterFactory implements IAdapterFactory {

	protected static final Class [] ADAPTER_LIST = { RuntimeInstallerAdapter.class };
	
	public Object getAdapter(Object adaptableObject, Class adapterType) {
		
		if( adapterType == RuntimeInstallerAdapter.class && adaptableObject instanceof IProject){
			IProject project = (IProject)adaptableObject;
			RuntimeInstallerAdapter adapter = null;

			//this should be extensible through an extension point that matches an adapter to a
			//nature id
			boolean isFacetted = false;
			
			try {
				isFacetted = project.hasNature( FacetedProjectNature.NATURE_ID );
			} catch (CoreException e) {
				e.printStackTrace();
			}
			
			if(  isFacetted ){
				adapter = new FacetAwareRuntimeInstallerAdapter();	
			}
			else{
				adapter = new SimpleRuntimeInstallerAdapter();
			}
			
			adapter.setProject( project );
			return adapter;
		}
		else{
			return null;
		}
	}

	public Class[] getAdapterList() {
		return ADAPTER_LIST;
	}

}
