package org.eclipse.atf.runtime.installer;

import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

/**
 * A IRuntimeInstaller is a strategy used to add/remove an AJAX Runtime into a Project. Depending
 * on the structure of the AJAX Runtime, there will be different implementations of a IRuntimeInstaller.
 * 
 * @author Gino Bustelo
 */
public interface IRuntimeInstaller {
	
	/**
	 * Add the specified instance of a Runtime to the specified IProject
	 * 
	 * @param runtimeInstance The instance of the Runtime to add.
	 * @param project The destination IProject
	 * @param monitor To track progress.
	 * @throws CoreException
	 */
	void install( IRuntimeInstance runtimeInstance, IProject project, IProgressMonitor monitor ) throws CoreException;
	
	/**
	 * Removes the specified instance of a Runtime from the specified IProject
	 * 
	 * @param runtimeInstance The instance of the Runtime to remove.
	 * @param project The destination IProject
	 * @param monitor To track progress.
	 * @throws CoreException
	 */
	void uninstall( IRuntimeInstance runtimeInstance, IProject project, IProgressMonitor monitor ) throws CoreException;
	
	public IPath getProjectInstallPath( IRuntimeInstance runtimeInstance );
}
