package org.eclipse.atf.runtime.validator;

import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/**
 * This class is the default validator for when no validator is defined. It simply
 * always return a valid response (OK).
 * 
 * @author Gino Bustelo
 *
 */
public final class AlwaysValidRuntimeValidator implements IRuntimeValidator {

	public IStatus validate(IRuntimeInstance instance) {
		return Status.OK_STATUS;
	}

}
