package org.eclipse.atf.runtime.validator;

import org.eclipse.atf.runtime.IRuntimeInstance;
import org.eclipse.core.runtime.IStatus;

/**
 * IRuntimeValidator makes sure that the location specified by the IRuntimeInstance
 * contains a valid instance of the IRuntimeInstance type.
 * 
 * @author Gino Bustelo
 *
 */
public interface IRuntimeValidator {
	
	/**
	 * This method will make sure that the IRuntimeInstace is a valid instance for the
	 * IRuntime type.
	 * 
	 * @param instance IRuntimeInstance to validate
	 * @return
	 */
	IStatus validate(IRuntimeInstance instance);
}
