package org.eclipse.atf.runtime.version;

import org.eclipse.atf.runtime.IRuntimeInstance;

/**
 * 
 * This inteface is used to implement a strategy for discovering the version of
 * an IRuntimeInstance.
 * 
 * @author Gino Bustelo
 */
public interface IVersionFinder {
	
	/**
	 * This method is called to find a version number in the specified
	 * IRuntimeInstance.
	 * 
	 * A returned null means that the version could not be found.
	 * 
	 * @param instance IRuntimeInstance to inspect for a version id
	 * @return
	 */
	String findVersion(IRuntimeInstance instance);
}
