/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.core;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.BundleContext;

/**
 * The main plugin class to be used in the desktop.
 */
public class MozideCorePlugin extends Plugin {

	public static final String PLUGIN_ID = "org.eclipse.atf.mozilla.ide.core";
	public static final String ATF_INTERNAL = "___ATF_INTERNAL";

	// The shared instance.
	private static MozideCorePlugin plugin;

	/**
	 * The constructor.
	 */
	public MozideCorePlugin() {
		plugin = this;
	}

	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static MozideCorePlugin getDefault() {
		return plugin;
	}

	// LOGGING METHODS
	public static void logInfo(String message) {
		log(IStatus.INFO, message, null);
	}

	public static void logWarning(String message) {
		log(IStatus.WARNING, message, null);
	}

	public static void logWarning(String message, Throwable e) {
		log(IStatus.WARNING, message, e);
	}

	public static void logError(String message) {
		logError(message, null);
	}

	public static void logError(String message, Throwable e) {
		log(IStatus.ERROR, message, e);
	}

	public static void log(int level, String message, Throwable e) {
		if (message == null) {
			message = ""; //$NON-NLS-1$
		}
		Status status = new Status(level, PLUGIN_ID, IStatus.OK, message, e);
		logStatus(status);
	}

	public static synchronized void logStatus(IStatus status) {
		getDefault().getLog().log(status);
	}
}
