/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.core;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

import org.mozilla.xpcom.GREVersionRange;
import org.mozilla.xpcom.Mozilla;

public class MozillaHelper {

	static final String XULRUNNER_PATH = "org.eclipse.swt.browser.XULRunnerPath"; //$NON-NLS-1$
	
	
	/**
	 * Use the first contributed Xulrunner that satisfies version ranges
	 *         constraints <br/>
	 *         Note: other potential Xulrunner contributions will be ignored
	 * @param range
	 */
	public static boolean definedContributedXulRunner(GREVersionRange[] range) {
		boolean isContributed = false;
		if (range == null) {
			range = new GREVersionRange[1];
			range[0] = new GREVersionRange("1.8.1.1", false, "1.8.1.*", true);
		}
		File grePath = getContributedXulRunner(range);
		if (grePath != null){
			System.setProperty(XULRUNNER_PATH, grePath.getAbsolutePath());
			isContributed = true;
		}
		return isContributed;
	}	
	
	/**
	 * Return the first contributed Xulrunner that satisfies version ranges
	 *         constraints <br/>
	 *         Note: other potential Xulrunner contributions will be ignored
	 * @param range
	 */
	static File getContributedXulRunner(GREVersionRange[] range) {
		XulRunnerExtensionReader xer = new XulRunnerExtensionReader();
	      Map contributedXulRunners = xer.getXulRunners();
	      for (Iterator iter = contributedXulRunners.keySet().iterator(); iter.hasNext();) {
	    	  File rootDir = (File) iter.next();
	    	  String version = (String) contributedXulRunners.get(rootDir);
	    	  for (int i = 0; i < range.length; i++) {
	    		  if (range[i].check(version)) {
	    			  return rootDir;
	    		  }
	    	  }
	      }
	      return null;
	}
}
