/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class MozillaErrorStatusHandler implements IStatusHandler {

	public Object handleStatus(final IStatus status, Object source)
			throws CoreException {

		DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), "JavaScript Error encountered", status.getMessage(), status);
		DebugUIPlugin.getStandardDisplay().syncExec(new Runnable() {

			public void run() {
				//TODO: Really should tie status line to the Debug view and not some random editor
				//TODO: also need to clear it?
				IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
				IWorkbenchWindow window = windows[0];
				if (window != null) {
					IWorkbenchPage page = window.getActivePage();
					if (page != null) {
						IEditorPart editor = page.getActiveEditor();
						IEditorSite site=  editor.getEditorSite();
						SubStatusLineManager statusLineManager = (SubStatusLineManager)site.getActionBars().getStatusLineManager();
						statusLineManager.setVisible(true);
						//TODO: add images?
						switch (status.getSeverity()) {
						case IStatus.ERROR:
							statusLineManager.setErrorMessage(status.getMessage());
							break;
						default:
							statusLineManager.setMessage(status.getMessage());
						}
					}
				}
			}
		});
		return null;
	}

}
