package org.eclipse.atf.mozilla.ide.debug.ui.internal.action;

import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugThread;
import org.eclipse.atf.mozilla.ide.debug.preferences.JSDebugPreferenceNames;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.actions.AbstractDebugActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;

public class BreakOnDebuggerKeywordMenuDelegate extends AbstractDebugActionDelegate {

	private ILaunch launch = null;

	public void selectionChanged(IAction action, ISelection s) {
		if( !s.isEmpty() ) {
			if( ((TreeSelection)s).getFirstElement() instanceof ILaunch ) {
				launch = (ILaunch)((TreeSelection)s).getFirstElement();
			} else if( ((TreeSelection)s).getFirstElement() instanceof JSDebugTarget ) {
				launch = ((JSDebugTarget)((TreeSelection)s).getFirstElement()).getLaunch();
			} else if( ((TreeSelection)s).getFirstElement() instanceof JSDebugThread ) {
				launch = ((JSDebugThread)((TreeSelection)s).getFirstElement()).getLaunch();
			} else if( ((TreeSelection)s).getFirstElement() instanceof JSDebugElement ) {
				launch = ((JSDebugElement)((TreeSelection)s).getFirstElement()).getLaunch();
			}
			if( launch != null ) {
				if( launch.getAttribute(JSDebugPreferenceNames.RUNTIME_SUSPEND_DEBUGGER) == null ) {
					try {
						if( launch.getLaunchConfiguration().getAttribute(JSDebugPreferenceNames.OVERRIDE_PREFERENCES,false) ) {
							getAction().setChecked(
									launch.getLaunchConfiguration().
									getAttribute(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD, false));
						} else {
							getAction().setChecked(MozillaDebugPlugin.getDefault().
									getPluginPreferences().getBoolean(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD));
						}
					} catch( CoreException ce ) {
						ce.printStackTrace();
					}
					
					launch.setAttribute(JSDebugPreferenceNames.RUNTIME_SUSPEND_DEBUGGER, 
							Boolean.toString(getAction().isChecked()));
				} else {
					getAction().setChecked(
							Boolean.valueOf(launch.getAttribute(JSDebugPreferenceNames.RUNTIME_SUSPEND_DEBUGGER)).booleanValue());
				}
				getAction().setEnabled(true);
			}
		} else {
			getAction().setEnabled(false);
			getAction().setChecked(false);
		}
	}

	protected void doAction(Object element) throws DebugException {
		if( launch != null && launch.getDebugTarget() != null ) {
			launch.setAttribute(JSDebugPreferenceNames.RUNTIME_SUSPEND_DEBUGGER, 
					Boolean.toString(getAction().isChecked()));
			JSDebugTarget debug = (JSDebugTarget)launch.getDebugTarget();
			if( getAction().isChecked() ) {
				try {
					if( debug.getThreads().length > 0 ) {
						debug.getDebuggerService().setDebuggerHook((JSDebugThread)debug.getThreads()[0]);
					}
				} catch (DebugException e) {
					e.printStackTrace();
				}
			} else {
				debug.getDebuggerService().setDebuggerHook(null);
			}
		}		
	}
}
