package org.eclipse.atf.mozilla.ide.debug.ui.preferences;

import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.preferences.JSDebugPreferenceNames;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class JSDebugPreferencePage extends PreferencePage implements
					IWorkbenchPreferencePage, Listener, ModifyListener {

	protected Preferences store;
	protected Button suspendAtStart;
	protected Button suspendOnErrors;
	protected Button suspendOnExceptions;
	protected Button suspendOnDebuggerKeyword;
	
	public JSDebugPreferencePage() {
		super();
		store = getPreferences();
	}
	
	public JSDebugPreferencePage(String title) {
		super(title);
		store = getPreferences();
	}
	
	public JSDebugPreferencePage(String title, ImageDescriptor descriptor) {
		super(title, descriptor);
		store = getPreferences();
	}
	protected Control createContents(Composite parent) {
		Composite composite = new Composite(parent, SWT.NULL);
		composite.setFont(parent.getFont());
		composite.setLayout(new GridLayout());
		composite.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		Group debugGroup = new Group(composite, SWT.NONE);
		GridLayout gridLayout = new GridLayout();
		gridLayout.numColumns = 1;
		debugGroup.setLayout(gridLayout);
		debugGroup.setLayoutData(new GridData(GridData.FILL_HORIZONTAL));
		debugGroup.setText("Javascript Debug Options");
		
		//Check boxes
		suspendAtStart = new Button(debugGroup, SWT.CHECK);
		suspendAtStart.setText("Suspend at start");
		suspendOnErrors = new Button(debugGroup, SWT.CHECK);
		suspendOnErrors.setText("Suspend on errors");
		suspendOnExceptions = new Button(debugGroup, SWT.CHECK);
		suspendOnExceptions.setText("Suspend on exceptions");
		suspendOnDebuggerKeyword = new Button(debugGroup, SWT.CHECK);
		suspendOnDebuggerKeyword.setText("Suspend on debugger keyword");
		
		setInitialValues();
		return composite;
	}
	
	private void setInitialValues() {
		suspendAtStart.setSelection(store.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE));
		suspendOnDebuggerKeyword.setSelection(store.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD));
		suspendOnErrors.setSelection(store.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_ERRORS));
		suspendOnExceptions.setSelection(store.getBoolean(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS));
	}
	
	private void setDefaultValues() {
		suspendAtStart.setSelection(store.getDefaultBoolean(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE));
		suspendOnDebuggerKeyword.setSelection(store.getDefaultBoolean(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD));
		suspendOnErrors.setSelection(store.getDefaultBoolean(JSDebugPreferenceNames.SUSPEND_ON_ERRORS));
		suspendOnExceptions.setSelection(store.getDefaultBoolean(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS));
	}
	
	private void setValues() {
		store.setValue(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE, suspendAtStart.getSelection());
		store.setValue(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD, suspendOnDebuggerKeyword.getSelection());
		store.setValue(JSDebugPreferenceNames.SUSPEND_ON_ERRORS, suspendOnErrors.getSelection());
		store.setValue(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS, suspendOnExceptions.getSelection());
		MozillaDebugPlugin.getDefault().savePluginPreferences();
	}
	
	protected Preferences getPreferences() {
		return MozillaDebugPlugin.getDefault().getPluginPreferences();
	}
	 
	public boolean performOk() {
		setValues();
		return super.performOk();
	}
	
	protected void performDefaults() {
		setDefaultValues();
	}

	public void init(IWorkbench workbench) {
		
	}

	public void handleEvent(Event event) {
		
	}

	public void modifyText(ModifyEvent e) {
		
	}

} 
