package org.eclipse.atf.mozilla.ide.debug.ui.util;

import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.util.SourceDisplayUtil;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.ui.IEditorInput;
import org.eclipse.wst.sse.ui.internal.StructuredResourceMarkerAnnotationModel;

public class DebuggerSourceDisplayUtil extends SourceDisplayUtil {

public IEditorInput getEditorInput(Object element) {
		
		IEditorInput editorInput = null;

		if (element instanceof IBreakpoint) {
			element = ((IBreakpoint)element).getMarker();
		}
		
		IMarker marker = null;
		if (element instanceof IMarker) {
			marker = (IMarker)element;
			element = ((IMarker)element).getResource();
		}

		//superclass defines the simple support for IFile and IStorage
		editorInput = super.getEditorInput( element );
		
		if( editorInput == null && element instanceof IWorkspaceRoot )
		{
			try {
				String id = (String)marker.getAttribute(StructuredResourceMarkerAnnotationModel.SECONDARY_ID_KEY);
				IStorage storage = SourceLocatorUtil.getInstance().getURLStorage(id);
				editorInput = new StorageEditorInput(storage);
			} catch (CoreException ce) {
				MozIDEUIPlugin.getDefault().getLog().log( new Status(IStatus.ERROR, MozIDEUIPlugin.ID, "Could not find markers for IWorkbenchRoot", ce) );
				// failed, so return null
			}
		}

		return editorInput;
		
	}
}
