package org.eclipse.atf.mozilla.ide.debug.model;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

import org.eclipse.atf.mozilla.ide.debug.JSDebugCoreMessages;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.core.internal.resources.Marker;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LineBreakpoint;

public class JSLineBreakpoint extends LineBreakpoint {
	
	private int _lineNumber;
	private String _id;

	public JSLineBreakpoint() {
		super();
	}

	/**
	 * The constructor required by the editor.
	 */	
	
	public JSLineBreakpoint(final IResource resource, final int lineNumber, final int charStart, final int charEnd, final boolean register, Map map) {
//		String location = resource.getLocation().toString();
//		System.out.println("JSLineBreakpoint(...) Location of resource: " + location);
		
		if (map == null)map = new HashMap();
		final Map attributes = map;
		IWorkspaceRunnable body = new IWorkspaceRunnable()
		{
			public void run(IProgressMonitor monitor) throws CoreException {		
				IMarker marker = resource.createMarker("org.eclipse.atf.mozilla.ide.debug.JSLineBreakpointMarker"); //$NON-NLS-1$
				attributes.put(IBreakpoint.ID, getModelIdentifier());
				attributes.put(IBreakpoint.ENABLED, new Boolean(true));
				attributes.put(IMarker.LINE_NUMBER, new Integer(lineNumber));
				attributes.put(IMarker.CHAR_START, new Integer(charStart));
				attributes.put(IMarker.CHAR_END, new Integer(charEnd));
				marker.setAttributes(attributes);
				setMarker(marker);	
			
				if (register) {
					registerBreakpoint();
				}
				setPersisted(true);
			}
		};

		try {
			ResourcesPlugin.getWorkspace().run(body, null);
		} catch (CoreException ce) {
			ce.printStackTrace();
		}
	}

	public String getModelIdentifier() {
		return MozillaDebugPlugin.DEBUG_MODEL_ID;
	}
	
	

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        _lineNumber = ((Integer)marker.getAttribute(IMarker.LINE_NUMBER)).intValue();
        // TODO: need to fix constant. This constant is StructuredResourceMarkerAnnotationModel.SECONDARY_ID_KEY
        //       which is in the sse UI plugin and didn't want to make this plugin dependent
        //       on a UI pligin
        _id = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path"); //$NON-NLS-1$
    }

	/**
	 * Adds the breakpoint information to the BreakpointManager
	 * @exception CoreException
	 */
	protected void registerBreakpoint() throws CoreException {
		DebugPlugin.getDefault().getBreakpointManager().addBreakpoint(this);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.debug.core.model.Breakpoint#setAttribute(java.lang.String, boolean)
	 */
	protected void setAttribute(String attributeName, boolean value)
		throws CoreException {
		
		super.setAttribute(attributeName, value);

		if (ENABLED.equals(attributeName))
			DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged(this);
	}

	public String getLabel() {
		try {
			IMarker marker = getMarker();
			IResource res = marker.getResource();
			String file;
			if (res instanceof IWorkspaceRoot) {
				file = getID();
			} else {
				file = marker.getResource().getName();
			}
			String line = Integer.toString(getLineNumber());
			return MessageFormat.format (JSDebugCoreMessages.JSDebugCore_5, new Object[] { file, line});
		} catch (CoreException ce) {
			MozillaDebugPlugin.log(ce);
			return JSDebugCoreMessages.JSDebugCore_4;
		}
	}

	public String getID() {
		return _id;
	}

	public int getLineNumber() throws CoreException  {
		// Try to get the line number from the marker. Use the stored line number
		// when the marker is not accessable. This seems to occur in the 
		// Mozilla callback when removing a breakpoint.
		try {
			_lineNumber = ((Integer)getMarker().getAttribute(IMarker.LINE_NUMBER)).intValue();
		} catch (CoreException e1){
			
		}
		return _lineNumber;
	}
	
	

	/* (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
//	public boolean equals(Object that) {
//		if (that instanceof JSLineBreakpoint) {
//			try {
//				JSLineBreakpoint bp = (JSLineBreakpoint)that;
//				return (bp.getLineNumber() == getLineNumber()) &&
//					getResource().equals(bp.getResource());
//			} catch (CoreException ce) {
//			}
//		}
//		return super.equals(that);
//	}
}
