/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.debug.model;

import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugStackFrame;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupParticipant;

// RSG - a hacked source participant. ATF used source locator instead of participant
// or source containers. The problem is that there can be only one source locator
// per launch. 

public class JSSourceLookupParticipant extends AbstractSourceLookupParticipant {	
	
	@Override
	public Object[] findSourceElements(Object object) throws CoreException {
		if (object instanceof JSDebugStackFrame){ 
			JSDebugStackFrame stackFrame = (JSDebugStackFrame) object;
			JSDebugTarget target = (JSDebugTarget)stackFrame.getDebugTarget();
			JSSourceLocator locator = target.getSourceLocator();
			return new Object [] {locator.getSourceElement(stackFrame)};
		}
		return null;
	}

	public String getSourceName(Object object) throws CoreException {
		String location = null;
		if (object instanceof JSDebugStackFrame) {
			location = ((JSDebugStackFrame)object).getRelativePath().toString();
		}
		return null;
	}

	
}