package org.eclipse.atf.mozilla.ide.debug.preferences;

import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

/*
 * This is the Preference Initializer for the JavaScript Debugger Plugins
 */
public class JSDebugPreferenceInitializer extends
		AbstractPreferenceInitializer {

	public void initializeDefaultPreferences() {
		IEclipsePreferences node = new DefaultScope().getNode(MozillaDebugPlugin.getDefault().getBundle().getSymbolicName());

		// formatting preferences
		node.putBoolean(JSDebugPreferenceNames.SUSPEND_ON_FIRST_LINE, false);
        node.putBoolean(JSDebugPreferenceNames.SUSPEND_ON_ERRORS, true);
        node.putBoolean(JSDebugPreferenceNames.SUSPEND_ON_EXCEPTIONS, false);
        node.putBoolean(JSDebugPreferenceNames.SUSPEND_ON_DEBUGGER_KEYWORD, true);
	}
}
