package org.eclipse.atf.mozilla.ide.ui.extras.actions;

import java.util.Iterator;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.wst.common.snippets.internal.SnippetsPlugin;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteDrawerFactory;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItem;
import org.eclipse.wst.common.snippets.internal.palette.SnippetPaletteItemFactory;
import org.eclipse.wst.common.snippets.internal.ui.SnippetsView;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMViewCSS;

/**
 * Adds a node's computed styles as a snippet to the
 * CSS drawer in the Snippets view.  Creates a CSS 
 * drawer if it does not exist.
 * 
 * @author Kevin Sawicki (ksawicki@us.ibm.com)
 *
 */
public class CSSSnippets extends DOMSelectionAction {
	
	public static final String CSS_DRAWER = "CSS";
	public static final String CSS_DESCRIPTION = "CSS Snippet";
	public static final String SNIPPETS_VIEW = SnippetsPlugin.NAMES.VIEW_ID;

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction#run()
	 */
	public void run() {
		if( !getSelection().isEmpty() ) {
			Shell shell = MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
			String drag = "";
			InputDialog dialog = new InputDialog(shell, "Add CSS Snippet", "Enter Snippet Name:", "", null);
			if( dialog.open() == InputDialog.OK ) {
				
				//Find the CSS drawer
				Iterator iter = SnippetsPlugin.getSnippetManager().getDefinitions().getCategories().iterator();
				PaletteDrawer drawer = null;
				while(iter.hasNext() ) {
					PaletteDrawer curr = (PaletteDrawer)iter.next();
					if( curr.getLabel().equals(CSSSnippets.CSS_DRAWER) ) {
						drawer = curr;
					}
				}
				
				//Create the drawer if not found
				if (drawer == null) {
					IWorkbench workbench = SnippetsPlugin.getDefault().getWorkbench();
					SnippetsView snippetsView = (SnippetsView)workbench.getActiveWorkbenchWindow().getActivePage().findView(SNIPPETS_VIEW);
					drawer = (PaletteDrawer)new SnippetPaletteDrawerFactory().createNewEntry(shell, snippetsView.getRoot());
					drawer.setLabel(CSSSnippets.CSS_DRAWER);
				}
				
				//Add all computed styles to the same string seperated by new lines
				nsIDOMElement domElement = (nsIDOMElement)(getSelection().getSelectedNode().queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID));
				nsIDOMDocumentView documentView = (nsIDOMDocumentView)domElement.getOwnerDocument().queryInterface( nsIDOMDocumentView.NS_IDOMDOCUMENTVIEW_IID );
				nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface( nsIDOMViewCSS.NS_IDOMVIEWCSS_IID );
				nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle( domElement, "" );
				for( int i = 0; i < computedStyle.getLength(); i++ ) {
					drag += computedStyle.item(i)+":"+computedStyle.getPropertyCSSValue(computedStyle.item(i)).getCssText()+";\n";							
				}
				
				//Add a new snippet palette item with the computed styles string
				try {
					SnippetPaletteItem item = (SnippetPaletteItem) new SnippetPaletteItemFactory().createNewEntry(shell, drawer);
					item.setDescription(CSSSnippets.CSS_DESCRIPTION);
					item.setLabel(dialog.getValue());
					item.setContentString(drag);
					MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(SNIPPETS_VIEW);
				} catch (PartInitException e1) {}
			}
		}
	}
}
