package org.eclipse.atf.mozilla.ide.ui.extras.actions;

import org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction;
import org.mozilla.interfaces.nsIDOMNode;

/**
 * Deletes the selected node.
 * 
 * @author Kevin Sawicki (ksawicki@us.ibm.com)
 *
 */
public class DeleteNodeAction extends DOMSelectionAction {

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction#run()
	 */
	public void run() {
		if( getSelection() != null && !getSelection().isEmpty() ) {
			try {
				nsIDOMNode node = getSelection().getSelectedNode();
				node.getParentNode().removeChild(node);
			} catch(Exception e) {}
		}
	}

}
