/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui;

import java.util.HashMap;

import org.eclipse.atf.mozilla.ide.core.MozideCorePlugin;
import org.eclipse.atf.mozilla.ide.ui.preferences.IPreferenceConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;


/**
 * The main plugin class to be used in the desktop.
 */
public class MozIDEUIPlugin extends AbstractUIPlugin {

	//The shared instance.
	private static MozIDEUIPlugin plugin;
	
	public static final String ID = "org.eclipse.atf.mozilla.ide.ui";
	
	//unique CLASS name to identify elements that are injected by ATF into the DOM and should be
	//filtered out of tooling (i.e. DOMInspector)
	public static final String ATF_INTERNAL = MozideCorePlugin.ATF_INTERNAL;
	
	//takes care of disposing the images
	protected HashMap imageDescMap = new HashMap();
	
	public static final String DEFAULT_IMAGE_ID = "__DEFAULT";
	
	public static final String E_BACK_IMG_ID 	= "E_BACK_IMG_ID";
	public static final String D_BACK_IMG_ID 	= "D_BACK_IMG_ID";
	public static final String E_FORWARD_IMG_ID = "E_FORWARD_IMG_ID";
	public static final String D_FORWARD_IMG_ID = "D_FORWARD_IMG_ID";
	public static final String E_REFRESH_IMG_ID = "E_REFRESH_IMG_ID";
	public static final String D_REFRESH_IMG_ID = "D_REFRESH_IMG_ID";
	public static final String E_STOP_IMG_ID 	= "E_STOP_IMG_ID";
	public static final String D_STOP_IMG_ID 	= "D_STOP_IMG_ID";
	public static final String E_GO_IMG_ID 		= "E_GO_IMG_ID";
	public static final String D_GO_IMG_ID 		= "D_GO_IMG_ID";
	public static final String SHOWMENU_IMG_ID 		= "SHOWMENU_IMG_ID";
	
	//console
	public static final String INFO_IMG_ID 		= "INFO_IMG_ID";
	public static final String ERROR_IMG_ID		= "ERROR_IMG_ID";
	public static final String WARNING_IMG_ID	= "WARNING_IMG_ID";
	public static final String EXCEPTION_IMG_ID	= "EXCEPTION_IMG_ID";
	public static final String CLEAR_IMG_ID		= "CLEAR_IMG_ID";
	
	//inspector
	public static final String DOCUMENT_IMG_ID	= "DOCUMENT_IMG_ID";
	public static final String ELEMENT_IMG_ID	= "ELEMENT_IMG_ID";
	public static final String TEXT_IMG_ID	= "TEXT_IMG_ID";
	public static final String COMMENT_IMG_ID = "COMMENT_IMG_ID";
	public static final String WAITING_IMG_ID	= "WAITING_IMG_ID";
	public static final String FILTERBYNAME_IMG_ID	= "FILTERBYNAME_IMG_ID";
	public static final String FILTERBYCLASS_IMG_ID	= "FILTERBYCLASS_IMG_ID";
	public static final String FILTERBYID_IMG_ID	= "FILTERBYID_IMG_ID";
	
	//source
	public static final String E_UPDATE_ID = "E_UPDATE_ID";
	public static final String E_REFRESH_ID = "E_REFRESH_ID";
	public static final String VALIDATE_ID = "VALIDATE_ID";
	
	//css
	public static final String HIGHLIGHT_ID = "HIGHLIGHT_ID";
	public static final String ADDPROPERTY_ID = "ADDPROPERTY_ID";
	public static final String EDITPROPERTY_ID = "EDITPROPERTY_ID";
	public static final String OPENFILE_ID = "OPENFILE_ID";
	
	//xhrmon
	public static final String COPYRESPONSE_ID = "COPYRESPONSE_ID";
	public static final String FILTERHTTP_ID = "FILTERHTTP_ID";
	public static final String FILTERXHR_ID = "FILTERXHR_ID";
	public static final String CSSFILTER_ID = "CSSFILTER_ID";
	public static final String HTMLFILTER_ID = "HTMLFILTER_ID";
	public static final String JSFILTER_ID = "JSFILTER_ID";
	public static final String IMGFILTER_ID = "IMGFILTER_ID";
	
	//toolbar
	public static final String CLOSE_TB_ID = "CLOSE_TB_ID";
	
	//watcher
	public static final String E_STARTWATCHER_ID = "E_STARTWATCHER_ID";
	public static final String D_STARTWATCHER_ID = "D_STARTWATCHER_ID";
	public static final String E_STOPWATCHER_ID = "E_STOPWATCHER_ID";
	public static final String D_STOPWATCHER_ID = "D_STOPWATCHER_ID";
	
	/**
	 * The constructor.
	 */
	public MozIDEUIPlugin() {
		plugin = this;
		
		getImageRegistry().put( DEFAULT_IMAGE_ID, getImageDescriptor("icons/sample.gif").createImage() );
		
		//common images
		imageDescMap.put( CLEAR_IMG_ID, getImageDescriptor("icons/common/clear.gif") );
		
		//browser images
		imageDescMap.put( E_BACK_IMG_ID, getImageDescriptor("icons/browser/e_back.gif") );
		imageDescMap.put( D_BACK_IMG_ID, getImageDescriptor("icons/browser/d_back.gif") );
		imageDescMap.put( E_FORWARD_IMG_ID, getImageDescriptor("icons/browser/e_forward.gif") );
		imageDescMap.put( D_FORWARD_IMG_ID, getImageDescriptor("icons/browser/d_forward.gif") );
		imageDescMap.put( E_REFRESH_IMG_ID, getImageDescriptor("icons/browser/e_refresh.gif") );
		imageDescMap.put( D_REFRESH_IMG_ID, getImageDescriptor("icons/browser/d_refresh.gif") );
		imageDescMap.put( E_STOP_IMG_ID, getImageDescriptor("icons/browser/e_stop.gif") );
		imageDescMap.put( D_STOP_IMG_ID, getImageDescriptor("icons/browser/d_stop.gif") );
		imageDescMap.put( E_GO_IMG_ID, getImageDescriptor("icons/browser/e_go.gif") );
		imageDescMap.put( D_GO_IMG_ID, getImageDescriptor("icons/browser/d_go.gif") );
		imageDescMap.put( SHOWMENU_IMG_ID, getImageDescriptor("icons/browser/showMenu.gif") );
			
		//js console images
		imageDescMap.put( ERROR_IMG_ID, getImageDescriptor("icons/console/error.gif") );
		imageDescMap.put( EXCEPTION_IMG_ID, getImageDescriptor("icons/console/exception.gif") );
		imageDescMap.put( INFO_IMG_ID, getImageDescriptor("icons/console/info.gif") );
		imageDescMap.put( WARNING_IMG_ID, getImageDescriptor("icons/console/warning.gif") );
		
		//inspector images
		imageDescMap.put( DOCUMENT_IMG_ID, getImageDescriptor("icons/inspector/document.gif") );
		imageDescMap.put( ELEMENT_IMG_ID, getImageDescriptor("icons/inspector/element.gif") );
		imageDescMap.put( TEXT_IMG_ID, getImageDescriptor("icons/inspector/text.gif") );
		imageDescMap.put( WAITING_IMG_ID, getImageDescriptor("icons/inspector/waiting.gif") );
		imageDescMap.put( COMMENT_IMG_ID, getImageDescriptor("icons/inspector/comment.gif") );
		imageDescMap.put( FILTERBYNAME_IMG_ID, getImageDescriptor("icons/inspector/filterByName.gif") );
		imageDescMap.put( FILTERBYCLASS_IMG_ID, getImageDescriptor("icons/inspector/filterByClass.gif") );
		imageDescMap.put( FILTERBYID_IMG_ID, getImageDescriptor("icons/inspector/filterById.gif") );
		
		//css images
		imageDescMap.put(HIGHLIGHT_ID, getImageDescriptor("icons/css/highlight.gif"));
		imageDescMap.put(ADDPROPERTY_ID, getImageDescriptor("icons/css/add_correction.gif"));
		imageDescMap.put(EDITPROPERTY_ID, getImageDescriptor("icons/css/write_obj.gif"));
		imageDescMap.put(OPENFILE_ID, getImageDescriptor("icons/css/goto_input.gif"));
		
		//source images
		imageDescMap.put(E_UPDATE_ID, getImageDescriptor("icons/source/e_prev_nav.gif"));
		imageDescMap.put(E_REFRESH_ID, getImageDescriptor("icons/source/e_next_nav.gif"));
		imageDescMap.put(VALIDATE_ID, getImageDescriptor("icons/source/testok.gif"));
		
		//xhrmon images
		imageDescMap.put(COPYRESPONSE_ID, getImageDescriptor("icons/xhrmon/copy_edit.gif"));
		imageDescMap.put(FILTERHTTP_ID, getImageDescriptor("icons/xhrmon/synced.gif"));
		imageDescMap.put(FILTERXHR_ID, getImageDescriptor("icons/xhrmon/cfilter.gif"));
		imageDescMap.put(CSSFILTER_ID, getImageDescriptor("icons/xhrmon/css_filter.gif"));
		imageDescMap.put(HTMLFILTER_ID, getImageDescriptor("icons/xhrmon/html_filter.gif"));
		imageDescMap.put(JSFILTER_ID, getImageDescriptor("icons/xhrmon/js_filter.gif"));
		imageDescMap.put(IMGFILTER_ID, getImageDescriptor("icons/xhrmon/image_filter.gif"));

		//toolbar images
		imageDescMap.put(CLOSE_TB_ID, getImageDescriptor("icons/toolbar/close_toolbar.gif"));
		
		//watcher images
		imageDescMap.put(E_STARTWATCHER_ID, getImageDescriptor("icons/watcher/startWatcher.gif"));
		imageDescMap.put(D_STARTWATCHER_ID, getImageDescriptor("icons/watcher/startWatcher_d.gif"));
		imageDescMap.put(E_STOPWATCHER_ID, getImageDescriptor("icons/watcher/stopWatcher.gif"));
		imageDescMap.put(D_STOPWATCHER_ID, getImageDescriptor("icons/watcher/stopWatcher_d.gif"));
		
	}

	
	public Image getImage( String imageID ){
		
		Image image = getImageRegistry().get( imageID );
		
		//need to create and add to registry
		if( image == null ){
			ImageDescriptor imgDescriptor = (ImageDescriptor)imageDescMap.get( imageID );
			
			if( imgDescriptor == null ){
				image = getImageRegistry().get( DEFAULT_IMAGE_ID );
			}
			else{
				//create the image and add to registry
				image = imgDescriptor.createImage();
				getImageRegistry().put( imageID, image );
			}
			
		}
		
		return image;

	}
	
	public ImageDescriptor getImageDescriptorFromRegistry( String imageID ){
		ImageDescriptor imgDescriptor = (ImageDescriptor)imageDescMap.get( imageID );
		return imgDescriptor;
	}
	
	/**
	 * This method is called upon plug-in activation
	 */
	public void start(BundleContext context) throws Exception {
		super.start(context);
		initializePreferences();
	}

	/**
	 * This method is called when the plug-in is stopped
	 */
	public void stop(BundleContext context) throws Exception {
		super.stop(context);
		plugin = null;
	}

	/**
	 * Returns the shared instance.
	 */
	public static MozIDEUIPlugin getDefault() {
		return plugin;
	}

	/**
	 * Returns an image descriptor for the image file at the given
	 * plug-in relative path.
	 *
	 * @param path the path
	 * @return the image descriptor
	 */
	public static ImageDescriptor getImageDescriptor(String path) {
		return AbstractUIPlugin.imageDescriptorFromPlugin("org.eclipse.atf.mozilla.ide.ui", path);
	}
	
	/**
	 * This method will initialize all the relevant preference in the store if they are not set.
	 */
	protected void initializePreferences(){
		IPreferenceStore store = getPreferenceStore();
		
		// setting up popup handling to prompt as default
		if( !store.contains( IPreferenceConstants.POPUP_HANDLING ) ){
			store.setDefault( IPreferenceConstants.POPUP_HANDLING, IPreferenceConstants.POPUP_HANDLING_PROMPT );
		}
		
	}
}