/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.ui.common.event.IDOMDocumentListener;
import org.eclipse.atf.mozilla.ide.ui.common.event.IDOMMutationListener;
import org.eclipse.core.runtime.IAdaptable;
import org.mozilla.interfaces.nsIDOMDocument;

public interface IWebBrowser extends IAdaptable{

	nsIDOMDocument getDocument();
	boolean isDocumentLoading();
	void addDOMDocumentListener( IDOMDocumentListener listener );
	void removeDOMDocumentListener( IDOMDocumentListener listener );
	void addDOMMutationListener( IDOMMutationListener listener );
	void removeDOMMutationListener( IDOMMutationListener listener );
	void setSelection(IDOMNodeSelection selection);
	WebBrowserType getType();
	
}
