/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class MozBrowserEditorPesistanceSuport implements IPersistableElement, IElementFactory{

	protected static final String ID = "org.eclipse.atf.mozilla.ide.ui.browser.memento";
	protected static final String MEMENTO_URL = "url";
	
	protected String url = null;
	
	public void setURL( String url ){
		this.url = url;
	}
	
	public void saveState(IMemento memento){
		memento.putString(MEMENTO_URL, url);		
	}

	public IAdaptable createElement(IMemento memento) {
		String persistedURL = null;
		

		try {
			persistedURL = memento.getString(MEMENTO_URL);
		} catch (Exception e) {
			//error processing memento
		}

		return new MozBrowserEditorInput(persistedURL);
	}

	public String getFactoryId() {
		return ID;
	}

}
