package org.eclipse.atf.mozilla.ide.ui.browser.toolbar;

import org.eclipse.atf.mozilla.ide.ui.browser.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.browser.IDOMNodeSelection;

/**
 * Interface for browser toolbars. The browser configured with the toolbar is
 * responsible for notifying the toolbar when the hover or node selection has
 * changed.
 * 
 * The toolbar can set the current node selection for the browser and subsequent
 * views by using the setSelection method provided by the IDOMDocumentContainer
 * interface.
 * 
 * @author Kevin Sawicki (ksawicki@us.ibm.com)
 * 
 */
public interface IBrowserToolbar {
	
	/**
	 * Sets the selection of the toolbar to the selection
	 * passed in.  Called by the browser when the selected
	 * node changes.
	 * 
	 * @param selection - Node selection
	 */
	public void setNodeSelection(IDOMNodeSelection selection);
	
	/**
	 * Sets the hover selection of the toolbar to the selection
	 * passed in.  Called by the browserr when the user hover
	 * over a DOM node.
	 * @param selection - Hover selection
	 */
	public void setHoverSelection(IDOMNodeSelection selection);
	
	/**
	 * Sets the browser for this toolbar.  The toolbar may
	 * interact with the browser via methods provided
	 * by the IDOMDocumenContainer interface.
	 * 
	 * @param browser - Browser containing this toolbar
	 */
	public void setBrowser(IWebBrowser browser);
	
}
