/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.browser.util;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserEditor;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserEditorInput;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.browser.Browser;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.ide.IDE;


/*
 * Collection of helper methods
 */
public class MozBrowserUtil {
	
	/*
	 * Open a Browser Editor to the specified URL and in the page provided
	 */
	public static Browser openMozillaBrowser( String url, IWorkbenchPage page ) throws CoreException{
		
		MozBrowserEditorInput editorInput = new MozBrowserEditorInput( url );
		
		IEditorPart editor = IDE.openEditor(page, editorInput, MozBrowserEditor.ID );
		
		if( editor instanceof MozBrowserEditor ){
			return ((MozBrowserEditor)editor).getMozillaBrowser();
		}
		else{
			throw new CoreException( new Status( IStatus.ERROR, MozIDEUIPlugin.ID, IStatus.ERROR, "Error opening Mozilla Browser... EditorPart did not initialize properly!", null ));
		}
	}
	
	/*
	 * Open a Browser Editor to the specified URL and in the currently active page
	 */
	public static Browser openMozillaBrowser( String url ) throws CoreException{
		
		IWorkbenchWindow activeWindow= MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
		if (activeWindow == null) {
			throw new CoreException( new Status( IStatus.ERROR, MozIDEUIPlugin.ID, IStatus.ERROR, "Error opening Mozilla Browser... failed to retrieve active workbench window!", null ));
		}
		IWorkbenchPage activePage= activeWindow.getActivePage();
		if (activePage == null) {
			throw new CoreException( new Status( IStatus.ERROR, MozIDEUIPlugin.ID, IStatus.ERROR, "Error opening Mozilla Browser... could not retrieve active page!", null ));
		}
		
		return openMozillaBrowser( url, activePage );
		
		
	}

}
