package org.eclipse.atf.mozilla.ide.ui.common.event;

import org.mozilla.interfaces.nsIDOMDocument;

/**
 * This event object contains context information relevant to event
 * related to DOM documents
 * 
 * @author Gino Bustelo
 */
public class DOMDocumentEvent {
	protected nsIDOMDocument targetDocument;
	
	protected boolean isTop; //true if topmost document, false if document in frame
	
	
	public DOMDocumentEvent( nsIDOMDocument targetDocument, boolean isTop ){
		this.targetDocument = targetDocument;
		this.isTop = isTop;
	}
	
	public boolean isTop() {
		return isTop;
	}
	public nsIDOMDocument getTargetDocument() {
		return targetDocument;
	}
	
	
}
