/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.console;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsIScriptError;

public class ConsoleMessageFilter extends ViewerFilter {

	protected int showMode = IJavaScriptConsole.SHOW_ALL;
	
	public ConsoleMessageFilter() {
		super();
	}

	public void setShowMode( int showMode ){
		this.showMode = showMode;
	}
	
	
	public boolean isFilterProperty(Object element, String property) {
		return super.isFilterProperty(element, property);
	}

	public boolean select(Viewer viewer, Object parentElement, Object element) {
		
		//check if it is an error and category contains XPConnect
		//these errors are internal and should always be filtered out
		try{
			nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
			nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
			
			if( scriptError.getCategory().indexOf("XPConnect") >= 0 ){
				return false;
			}
		}
		catch( Exception e ){
			//keep going
		}
		
		switch( showMode ){
		
		case IJavaScriptConsole.SHOW_ALL:
			return true;
			
		case IJavaScriptConsole.SHOW_ERRORS:
			try{
				nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
				nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
				return scriptError.getFlags() == nsIScriptError.errorFlag || scriptError.getFlags() == nsIScriptError.exceptionFlag;
			}
			catch( Exception e ){
				return false; //simple message
			}
		
		
		case IJavaScriptConsole.SHOW_WARNINGS:
			try{
				nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
				nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
				return scriptError.getFlags() == nsIScriptError.warningFlag;
			}
			catch( Exception e ){
				return false; //simple message
			}
	
		case IJavaScriptConsole.SHOW_MESSAGES:
			try{
				nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
				consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
				return false; //if able to QI to ScriptError then it is not a message
			}
			catch( Exception e ){
				return true; //simple message
			}
		
		default:
			return true;
		}
	}
}
