/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.console;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsIScriptError;


public class ConsoleMessageLabelProvider extends LabelProvider implements ITableLabelProvider{

	protected static final int IMAGE_COLUMN_INDEX = 0;
	protected static final int CATEGORY_COLUMN_INDEX = 1;
	protected static final int MSG_COLUMN_INDEX = 1;
	protected static final int SRCNAME_COLUMN_INDEX = 2;
	protected static final int LINENUM_COLUMN_INDEX = 3;
	
	public Image getColumnImage(Object element, int columnIndex) {
		
		//check if it's the first column (the only one that contains an image)
		if( columnIndex == IMAGE_COLUMN_INDEX ) {
		
			//handle simple String messages
			if( element instanceof String ){
				return getInfoImage();
			}
			
			
			nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
			
			//test if it is an nsIScriptError type
			try{
				nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
				
				if ( scriptError.getFlags() == nsIScriptError.errorFlag )
					return getErrorImage();
				else if( scriptError.getFlags() == nsIScriptError.warningFlag )
					return getWarningImage();
				else if( scriptError.getFlags() == nsIScriptError.exceptionFlag )
					return getExceptionImage();
			}
			catch( Exception e ){
				//nothing , the message is not an nsIScriptError type
			}
			return getInfoImage();
		} else if( columnIndex == CATEGORY_COLUMN_INDEX ) {
			if( element instanceof nsIConsoleMessage ) {
				nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
				
				//test if it is an nsIScriptError type
				try{
					nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
					String category = scriptError.getCategory();
					if( category.indexOf("CSS") != -1 ) {
						return getCSSImage();
					}
					if( category.indexOf("javascript") != -1 ) {
						return getJSImage();
					}
					if( category.indexOf("XML") != -1  || category.indexOf("malformed-xml") != -1 ) {
						return getXMLImage();
					}
				}
				catch( Exception e ){
					//nothing , the message is not an nsIScriptError type
				}
			}
		}
		
		return null;
		
	}

	public String getColumnText(Object element, int columnIndex) {
		
		//first column is always an image
		if( columnIndex == IMAGE_COLUMN_INDEX )
			return null;
		
		//handle simple String messages
		if( element instanceof String ){
			if( columnIndex == MSG_COLUMN_INDEX ){
				return element.toString();
			}
			else
				return null;
		}
		
		nsIConsoleMessage consoleMessage = (nsIConsoleMessage)element;
		
		//test if it is an nsIScriptError type
		try{
			nsIScriptError scriptError = (nsIScriptError)consoleMessage.queryInterface( nsIScriptError.NS_ISCRIPTERROR_IID );
			if( columnIndex == MSG_COLUMN_INDEX ) //message
				return scriptError.getErrorMessage() + ":" + scriptError.getSourceLine();
			else if( columnIndex == SRCNAME_COLUMN_INDEX )
				return scriptError.getSourceName();
			else if( columnIndex == LINENUM_COLUMN_INDEX )
				return String.valueOf(scriptError.getLineNumber())+':'+String.valueOf(scriptError.getColumnNumber());
		}
		catch( Exception e ){
			//nothing , the message is not an nsIScriptError type
		}
		
		if( columnIndex == MSG_COLUMN_INDEX ){
			return consoleMessage.getMessage();
		}
		
		return null;
	}
	
	protected Image getCSSImage() {
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.CSSFILTER_ID );
	}
	
	protected Image getJSImage() {
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.JSFILTER_ID );
	}
	
	protected Image getXMLImage() {
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.HTMLFILTER_ID );
	}
	
	protected Image getInfoImage(){
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.INFO_IMG_ID );
	}
	
	protected Image getErrorImage(){
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.ERROR_IMG_ID );
	}
	
	protected Image getWarningImage(){
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.WARNING_IMG_ID );
	}
	
	protected Image getExceptionImage(){
		return MozIDEUIPlugin.getDefault().getImage( MozIDEUIPlugin.EXCEPTION_IMG_ID );
	}

	
}
