/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.console;

import org.mozilla.interfaces.nsIConsoleMessage;

/*
 * Interfaces used to communicate with the console
 */
public interface IJavaScriptConsole {
	static final int MAX_MESSAGE_COUNT = 250;
	
	static final int SHOW_ALL 		= 0;
	static final int SHOW_ERRORS 	= 1;
	static final int SHOW_WARNINGS 	= 2;
	static final int SHOW_MESSAGES 	= 3;
	
	void logConsoleMessage( String message );
	void logConsoleMessage( nsIConsoleMessage message );
	void clearMessages();
	void setShowMode( int mode );

}
