/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.console;

import org.mozilla.interfaces.nsIConsoleListener;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

public class JavaScriptConsoleListener implements nsIConsoleListener {

	protected IJavaScriptConsole jsConsole = null;
	
	public JavaScriptConsoleListener( IJavaScriptConsole jsConsole) {
		this.jsConsole = jsConsole;
	}

	public void observe(final nsIConsoleMessage consoleMessage) {
		//ignore if jsConsole is not available
		if( jsConsole == null )
			return;
		
		jsConsole.logConsoleMessage( consoleMessage );
	}

	public nsISupports queryInterface(String id) {
		return Mozilla.queryInterface(this, id);
	}

}
