package org.eclipse.atf.mozilla.ide.ui.css;


import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;

/**
 * Label provider for CSS Tree.  Returns an images and text
 * for each column for the properties for each CSS rule and 
 * computed style from a element DOM node.
 * 
 * @author Kevin Sawicki (ksawicki@us.ibm.com)
 *
 */
public class CSSLabelProvider implements ITableLabelProvider {
	//Labels for each tree column value
	public static final String[] COLUMNS = { "Rule", "Property", "Value", "URL", "Line Number" };
	
	//Device used when creating images
	private Device device;

	/**
	 * Creates a new label provider with a device for
	 * image creations
	 * @param device - device to used when creating images
	 */
	public CSSLabelProvider(Device device ) {
		super();
		this.device = device;
	}
	
	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		
		/**
		 * Only return images for the 2nd and 3rd columns
		 */
		if( element instanceof CSSProperty && columnIndex == 2) {
			/**
			 * Paints a color image matching the color specified
			 * by the property value
			 */
			if( ((CSSProperty)element).isColor() ) {
				CSSProperty property = ((CSSProperty)element);
				if( property.getValue().indexOf("rgb") != -1 
					&& property.getValue().indexOf('%') == -1 ) {
					String value = property.getValue().substring(property.getValue().indexOf('(')+1);
					int red = Integer.parseInt(value.substring(0, value.indexOf(',')).trim());
					value = value.substring(value.indexOf(',')+1);
					int green = Integer.parseInt(value.substring(0, value.indexOf(',')).trim());
					value = value.substring(value.indexOf(',')+1);
					int blue = Integer.parseInt(value.substring(0, value.indexOf(')')).trim());
					RGB[] colors = { new RGB(red,green,blue) };
					PaletteData pd = new PaletteData(colors);
					ImageData id = new ImageData(50,10,1,pd);
					Image img2 = new Image(device,id);
					return img2;
				} else if( property.getValue().startsWith("#")) {
					String value = property.getValue().substring(property.getValue().indexOf('#')+1);
					if( value.length() == 6 ) {
						int red = Integer.parseInt(value.substring(0,2), 16);
						int green = Integer.parseInt(value.substring(2,4), 16);
						int blue = Integer.parseInt(value.substring(4,6), 16);
						RGB[] colors = { new RGB(red,green,blue) };
						PaletteData pd = new PaletteData(colors);
						ImageData id = new ImageData(50,10,1,pd);
						Image img2 = new Image(device,id);
						return img2;
					} else  if( value.length() == 3 ) {
						int red = Integer.parseInt(value.substring(0,1)+value.substring(0,1), 16);
						int green = Integer.parseInt(value.substring(1,2)+value.substring(1,2), 16);
						int blue = Integer.parseInt(value.substring(2,3)+value.substring(2,3), 16);
						RGB[] colors = { new RGB(red,green,blue) };
						PaletteData pd = new PaletteData(colors);
						ImageData id = new ImageData(50,10,1,pd);
						Image img2 = new Image(device,id);
						return img2;
					} else {
						return null;
					}
				} else if( property.getRGBValue() != null && property.isPresent() ) {
					String value = property.getRGBValue().substring(property.getRGBValue().indexOf('(')+1);
					int red = Integer.parseInt(value.substring(0, value.indexOf(',')).trim());
					value = value.substring(value.indexOf(',')+1);
					int green = Integer.parseInt(value.substring(0, value.indexOf(',')).trim());
					value = value.substring(value.indexOf(',')+1);
					int blue = Integer.parseInt(value.substring(0, value.indexOf(')')).trim());
					RGB[] colors = { new RGB(red,green,blue) };
					PaletteData pd = new PaletteData(colors);
					ImageData id = new ImageData(50,10,1,pd);
					Image img2 = new Image(device,id);
					return img2;					
				}
			} 
			
		/**
		 * Creates a green square if the property is current being applied to the selected node
		 * Creates a red square if the property has been overwritten and not current applied
		 * to the node
		 */
		} else if( element instanceof CSSProperty && columnIndex == 1 && !((CSSProperty)element).getName().equals("") ) {
			if( ((CSSProperty)element).isPresent() ) {
				RGB[] colors = { new RGB(0,200,0) };
				PaletteData pd = new PaletteData(colors);
				ImageData id = new ImageData(10,10,1,pd);
				Image img2 = new Image(device,id);
				return img2;
			} else {
				RGB[] colors = { new RGB(200,0,0) };
				PaletteData pd = new PaletteData(colors);
				ImageData id = new ImageData(10,10,1,pd);
				Image img2 = new Image(device,id);
				return img2;
			}
		}
		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		if( element instanceof CSSProperty ) {
			CSSProperty property = (CSSProperty)element;
			if( columnIndex == 0 ) {
				if( property.isProperty() ) {
					return "";
				} else if( property.isRule() ) {
					return property.getRule();
				}
			} else  if( columnIndex == 1 ) {
					return property.getName();
					
			}
			if( columnIndex == 2 ) {
				if( property.isColor() ) {
					return property.getValue();
				} else {
					return property.getValue();
				}
			}
			if( columnIndex == 3 ) {
				if( property.isRule() || property.isComputed() ) {
					return property.getURL();
				}
			}
			if( columnIndex == 4 ) {
				if( property.isRule() || property.isComputed() ) {
					return property.getLineNumber();
				} else {
					return "";
				}
			}
		}
		return "";
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#dispose()
	 */
	public void dispose() {
		
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#isLabelProperty(java.lang.Object, java.lang.String)
	 */
	public boolean isLabelProperty(Object element, String property) {
		return false;
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#removeListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void removeListener(ILabelProviderListener listener) {
		
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IBaseLabelProvider#addListener(org.eclipse.jface.viewers.ILabelProviderListener)
	 */
	public void addListener(ILabelProviderListener listener) {
		
	}

}
