/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.inspector;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.inspector.DOMContentProvider.MessageNode;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;


public class DOMLabelProvider extends LabelProvider {

	public Image getImage(Object element) {
		
		//MessageNode(s) do not have images
		if( element instanceof MessageNode )
			return MozIDEUIPlugin.getDefault().getImage(MozIDEUIPlugin.WAITING_IMG_ID);
		
		switch(((nsIDOMNode)element).getNodeType()){
		
		case nsIDOMNode.DOCUMENT_NODE:
			return MozIDEUIPlugin.getDefault().getImage(MozIDEUIPlugin.DOCUMENT_IMG_ID);
		
		case nsIDOMNode.ELEMENT_NODE:
			return MozIDEUIPlugin.getDefault().getImage(MozIDEUIPlugin.ELEMENT_IMG_ID);
		
		case nsIDOMNode.TEXT_NODE:
			return MozIDEUIPlugin.getDefault().getImage(MozIDEUIPlugin.TEXT_IMG_ID);
			
		case nsIDOMNode.COMMENT_NODE:
			return MozIDEUIPlugin.getDefault().getImage(MozIDEUIPlugin.COMMENT_IMG_ID);
		
		case nsIDOMNode.CDATA_SECTION_NODE:
			
		default:
			return null;
		}
	}

	public String getText(Object element) {
		
		//MessageNode(s) do not have images
		if( element instanceof MessageNode )
			return ((MessageNode)element).message;
		
		nsIDOMNode node = (nsIDOMNode)element;
		
		StringBuffer buf = new StringBuffer();
		
		buf.append( node.getNodeName() );
		
		//try to get the id if available
		if( node.getNodeType() == nsIDOMNode.ELEMENT_NODE ){
			try{
				nsIDOMElement e = (nsIDOMElement)node.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
				String id = e.getAttribute("id");
				
				if( !(id == null || "".equals(id)) ){
					
					buf.append( " [" );
					buf.append( id );
					buf.append( "]" );
				}
			}
			catch( Exception e ){
				//do nothing
			}
		}
		
		return buf.toString();
	}
}
