/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import org.mozilla.interfaces.nsIBoxObject;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNSDocument;
import org.mozilla.interfaces.nsIDOMNode;

/*
 * This implementation knows how to get BOX model values for a given DOM node
 */
public class BoxModelProperty implements IDOMInspectorProperty {

	public static String X_PROP = "x";
	public static String Y_PROP = "y";
	public static String WIDTH_PROP = "width";
	public static String HEIGHT_PROP = "height";
	
	protected String displayName = "";
	protected String propertyName = "";
	
	public BoxModelProperty( String propertyName, String displayName ){
		this.propertyName = propertyName;
		this.displayName = displayName;
	}
	
	public String getDisplayName() {
		return displayName;
	}


	public String getValue(nsIDOMNode node) {
		
		try{
			nsIDOMElement element = (nsIDOMElement)node.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
			
			nsIDOMNSDocument nsDocument = (nsIDOMNSDocument)node.getOwnerDocument().queryInterface( nsIDOMNSDocument.NS_IDOMNSDOCUMENT_IID );
			nsIBoxObject elementBox = (nsIBoxObject)nsDocument.getBoxObjectFor( element );
			
			if( X_PROP.equals(propertyName) )
				return String.valueOf(elementBox.getX());
			
			else if( Y_PROP.equals(propertyName) )
				return String.valueOf(elementBox.getY());
			
			else if( WIDTH_PROP.equals(propertyName) )
				return String.valueOf(elementBox.getWidth());
			
			else if( HEIGHT_PROP.equals(propertyName) )
				return String.valueOf(elementBox.getHeight());
			
			else
				return "INVALID PROPERTY NAME!";
		}
		catch( Exception e ){
			e.printStackTrace();
			return "ERROR!";
		}
		
		
	}

}
