/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.mozilla.interfaces.nsIDOMNode;

/*
 * This implementation is used to aggregate a set of strategies
 */
public class CompositeProperty implements IDOMInspectorProperty {

	protected String displayName = "";
	protected List properties = new ArrayList();
	
	protected String separator = " ";
	
	public CompositeProperty( String displayName ){
		this.displayName = displayName;		
	}
	
	public CompositeProperty( String displayName, String separator ){
		this( displayName );
		this.separator = separator;
	}
	
	public String getDisplayName() {
		return this.displayName;
	}

	public String getValue(nsIDOMNode node) {
		
		StringBuffer value = new StringBuffer();
		
		for (Iterator iter = properties.iterator(); iter.hasNext();) {
			IDOMInspectorProperty property = (IDOMInspectorProperty) iter.next();
			
			value.append( property.getValue(node) );
			
			if( iter.hasNext() )
				value.append( separator );
			
		}
		
		return value.toString();
	}

	public void addProperties( IDOMInspectorProperty property ){
		properties.add( property );
	}
	
	public void removeProperties( IDOMInspectorProperty property ){
		properties.remove( property );
	}
}
