/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMViewCSS;

/*
 * This implementation knows how to get the computed style for a given DOM node
 */
public class ComputedStyleProperty implements IDOMInspectorProperty {

	public String displayName = "";
	public String styleName = "";
	
	public ComputedStyleProperty( String styleName, String displayName ){
		this.styleName = styleName;
		this.displayName = displayName;
	}
	public String getDisplayName() {
		return displayName;
	}

	public String getValue(nsIDOMNode node) {
		
		try{
			
			nsIDOMElement element = (nsIDOMElement)node.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
			
			nsIDOMDocumentView documentView = (nsIDOMDocumentView)element.getOwnerDocument().queryInterface( nsIDOMDocumentView.NS_IDOMDOCUMENTVIEW_IID );
			nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface( nsIDOMViewCSS.NS_IDOMVIEWCSS_IID );
			
			nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle( element, "" );
			
			return computedStyle.getPropertyCSSValue(styleName).getCssText();
		
		}
		catch( Exception e ){
			System.err.println( "Failed getting computed style <"+styleName+"> with error<"+e.getMessage()+">!");
			return "ERROR!";
		}
	}

}
