/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/

package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

/**
 * @author Gino Bustelo
 *
 */
public class DOMAttributeEditDialog extends DOMAttributeAddDialog {

	public DOMAttributeEditDialog(Shell shell, String attributeName, String attributeValue ) {
		super(shell);
		
		this.title = "Edit DOM Attribute:";
		this.attributeName = attributeName;
		this.attributeValue = attributeValue;
	}

	protected Control createDialogArea(Composite parent) {
		Control retControl = super.createDialogArea(parent);
		
		attributeNameText.setEditable(false);
		attributeNameText.setText( attributeName );
		
		attributeValueText.setText( attributeValue );
		
		return retControl;
	}

	
}
