/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;

/*
 * This implementation knows how to get the value for a DOM attribute for a given DOM node
 */
public class DOMAttributeProperty implements IDOMInspectorEditableProperty {

	protected String displayName = "";
	protected String attributeName = "";
	
	public DOMAttributeProperty( String attributeName, String displayName ){
		this.attributeName = attributeName;
		this.displayName = displayName;
	}
	
	public String getDisplayName() {
		return displayName;
	}
	
	public String getName(){
		return attributeName;
	}

	public String getValue(nsIDOMNode node) {
		
		try{
			
			nsIDOMElement element = (nsIDOMElement)node.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
			
			return element.getAttribute( attributeName );
		
		}
		catch( Exception e ){
			e.printStackTrace();
			return "ERROR!";
		}
	}

	public void setValue(nsIDOMNode node, String value) {
		
		try{
			
			nsIDOMElement element = (nsIDOMElement)node.queryInterface(nsIDOMElement.NS_IDOMELEMENT_IID);
			
			element.setAttribute( attributeName, value );
		
		}
		catch( Exception e ){
			e.printStackTrace();
		}
		
	}

}
