package org.eclipse.atf.mozilla.ide.ui.jseval.model;

import java.util.HashMap;

public class JSObject extends BaseJSValue {
	
	protected HashMap props = new HashMap();
	
	public boolean evaluated = false;
	
	public String getType(){
		return IJSValue.OBJECT;
	}
	
	public void addProperty( JSObjectProperty prop ){
		prop.parentObject = this;
		props.put( prop.name, prop );
	}
	
	public JSObjectProperty[] getProperties(){
		JSObjectProperty [] ret = new JSObjectProperty[ props.size() ];
		return (JSObjectProperty [])props.values().toArray(ret);
	}
	
	public void setProperties( JSObjectProperty [] propsIn ){
		props.clear();
		for (int i = 0; i < propsIn.length; i++) {
			addProperty( propsIn[i] );
		}
		
	}
}
