/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHeader;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;


public class HeaderLabelProvider extends LabelProvider implements
		ITableLabelProvider {

	protected static final int NAME_COL_INDEX = 0;
	protected static final int VALUE_COL_INDEX = 1;
	
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		//the elements are IHeader
		if( columnIndex == NAME_COL_INDEX )
			return ((IHeader)element).getName();
		else if ( columnIndex == VALUE_COL_INDEX )
			return ((IHeader)element).getValue();
		else
			return null; //unknown column
	}

}
