/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2007 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.INetworkCall;

/**
 * This interface is used to label the class that implements the viewable
 * part of the network monitor.
 * 
 *  
 * @author Gino Bustelo
 *
 */
public interface INetworkMonitor {

	/**
	 * A new call has been logged
	 * @param call
	 */
	void notifyCallAdded(INetworkCall call);

	/**
	 * A call had been updated with new information
	 * 
	 * @param call
	 */
	void notifyCallUpdated(INetworkCall call);

}
