/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2007 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.INetworkCallList;

/**
 * This interface is used by classes that implement the actual platform specific
 * way of collecting network communication information. It is used by the INetworkMonitor
 * to get access to the list of calls and also get notified of network progress.
 * 
 * @author Gino Bustelo
 *
 */
public interface INetworkMonitorAdapter {

	/**
	 * Hook to the platform to start collecting network communication information
	 */
	void connect();
	
	/**
	 * Unhook and cleanup from the platform to stop collecting network communication
	 * information
	 */
	void disconnect();
	
	/**
	 * Get the ongoing list of network calls
	 * 
	 * @return
	 */
	INetworkCallList getCallList();
}
