/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2006 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.Date;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHTTPResponse;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.INetworkCall;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IRequest;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IResponse;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;


public class NetworkCallLabelProvider extends LabelProvider implements
		ITableLabelProvider {

	public static final String DONE_IMAGE 	= "done";
	public static final String ERROR_IMAGE  = "error";
	public static final String WARNING_IMAGE = "warning";
	public static final String RUNNING_IMAGE = "waiting";

	private static ImageRegistry imageRegistry = new ImageRegistry();

	/**
	 * Note: An image registry owns all of the image objects registered with it,
	 * and automatically disposes of them the SWT Display is disposed.
	 */ 
	static {
		String iconPath = "icons/xhrmon/"; 
		imageRegistry.put(DONE_IMAGE, MozIDEUIPlugin.getImageDescriptor(iconPath + DONE_IMAGE + ".gif"));
		imageRegistry.put(ERROR_IMAGE, MozIDEUIPlugin.getImageDescriptor(iconPath + ERROR_IMAGE + ".gif"));
		imageRegistry.put(WARNING_IMAGE, MozIDEUIPlugin.getImageDescriptor(iconPath + WARNING_IMAGE + ".gif"));
		imageRegistry.put(RUNNING_IMAGE, MozIDEUIPlugin.getImageDescriptor(iconPath + RUNNING_IMAGE + ".gif"));
	}

	/**
	 * Returns the image based on the state of the specified IXHRCall.
	 * 
	 * @param call
	 * @return
	 */
	private Image getImage(INetworkCall call) {
		if(call.getState().equals(INetworkCall.ACTIVE_STATE))
			return imageRegistry.get(RUNNING_IMAGE);
		else if(call.getState().equals(INetworkCall.ERROR_STATE))
			return imageRegistry.get(ERROR_IMAGE);
		else if(call.getState().equals(INetworkCall.WARNING_STATE))
			return imageRegistry.get(WARNING_IMAGE);
		else if(call.getState().equals(INetworkCall.SUCCESS_STATE))
			return imageRegistry.get(DONE_IMAGE);
		return  null;
	}
	
	public Image getColumnImage(Object element, int columnIndex) {
		INetworkCall call = (INetworkCall)element;
		switch(columnIndex) {
			case 0:
				return getImage(call);
		}
		return null;
	}

	public String getColumnText(Object element, int columnIndex) {
		String result = "";
		INetworkCall call = (INetworkCall) element;
		switch (columnIndex) {
			case 0:  // STATE_COLUMN
				break;
			
			case 1 : // URL COLUMN
				result = call.getRequest().getURL();
				break;
			
			case 2 : // METHOD COLUMN
			{
				IRequest req = call.getRequest();
				if( req instanceof IHTTPRequest )
					result = ((IHTTPRequest)req).getMethod();
				
				break;
			}			
			case 3 : //START TIME COLUMN
				long startTime = call.getStartTime();
				if( startTime != -1 )
					result = new Date(startTime).toString();
				break;
			
			case 4 : //END TIME COLUMN
				long endTime = call.getEndTime();
				if( endTime != -1 )
					result = new Date(endTime).toString();

				break;
				
			case 5 : //TOTAL TIME COLUMN
				long totalTime = call.getTotalTime();
				
				if( totalTime != -1 )
					result = totalTime + " ms";
				break;
				
			case 6 : //STATUS COLUMN
			{
				IResponse res = call.getResponse();
				if( res instanceof IHTTPResponse )
					result = ((IHTTPResponse)res).getStatus();
				break;
			}
			default :
				break; 	
		}
		return result;
	}

}
