package org.eclipse.atf.mozilla.ide.ui.netmon.filter;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.IContentTypeConstants;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHeader;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHeaderContainer;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.INetworkCall;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IResponse;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

abstract public class MimeTypeViewerFilter extends ViewerFilter {

	public boolean select(Viewer viewer, Object parentElement, Object element) {
		
		IResponse res = ((INetworkCall)element).getResponse();
		
		if( res != null && res instanceof IHeaderContainer ){
			IHeader contentTypeHeader = ((IHeaderContainer)res).getHeader(IContentTypeConstants.CONTENT_TYPE_HEADER);
			
			//set to ? because an enpty string will match with the first check
			String type = "?";
			if( contentTypeHeader != null ){
				type = contentTypeHeader.getValue();
			}
			
			//parse out the mime type
			int mimeDelim = type.indexOf(';');
			if( mimeDelim != -1 ){
				type = type.substring( 0, mimeDelim );
			}
			
			return (getMimeTypeCompareString().indexOf(type) != -1 );
		}
		else
			return false;
		
	}
	
	abstract protected String getMimeTypeCompareString(); 
}
