/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2007 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon.model;

public interface INetworkCall {

	static final String ACTIVE_STATE = "ACTIVE";
	static final String SUCCESS_STATE = "SUCCESS";
	static final String WARNING_STATE = "WARNING";
	static final String ERROR_STATE = "ERROR";
	
	IRequest getRequest();
	IResponse getResponse();
	
	/**
	 * One of the four states (ACTIVE | SUCCESS | WARNING | ERROR)
	 * @return
	 */
	String getState();
	
	/**
	 * The time in ms representing the start time of the call
	 * 
	 * -1 if not set
	 * @return
	 */
	long getStartTime();
	
	/**
	 * The time in ms representing the end time of the call
	 * 
	 * -1 if not set
	 * @return
	 */
	long getEndTime();
	
	/**
	 * The time in ms representing the total time of the call
	 * 
	 * -1 if not set
	 * @return
	 */
	int getTotalTime();
}
