/*******************************************************************
 *
 * Licensed Materials - Property of IBM
 * 
 * AJAX Toolkit Framework 6-28-496-8128
 * 
 * (c) Copyright IBM Corp. 2007 All Rights Reserved.
 * 
 * U.S. Government Users Restricted Rights - Use, duplication or 
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
 *
 *******************************************************************/
package org.eclipse.atf.mozilla.ide.ui.netmon.model;

import org.eclipse.atf.mozilla.ide.ui.netmon.INetworkMonitor;


public interface INetworkCallList {

	/**
	 * This method adds a new call to the monitor. This call object is a call
	 * in progress and future notifications from the browser environment are
	 * needed to update the information for this call. 
	 * 
	 * Since there will be a need to get access to this instance for update, we
	 * need to map.
	 * 
	 * For mozilla, the mapKey could be an instance of the nsIRequest object that
	 * the call is representing.
	 * 
	 * @param call
	 * @param mapKey - Object used as the key to the map
	 */
	void add( INetworkCall call, Object mapKey );
	
	
	/**
	 * This method is used to get access of a call instance that is mapped to
	 * the mapKey parameter.
	 * 
	 * For mozilla, the mapKey could be an instance of the nsIRequest object that
	 * the call is representing.
	 * 
	 * @param mapKey - Object used as the key to the map
	 */
	INetworkCall get( Object mapKey );
	
	/**
	 * Gets an array of all the calls in the list
	 * 
	 * @return
	 */
	INetworkCall[] getAll();
	
	/**
	 * This call is necessary to release the reference of mapKey, which could
	 * be a native instance.
	 * 
	 * @param mapKey - Object used as the key to the map
	 */
	void removeMap( Object mapKey );
	
	/**
	 * 
	 * @param call
	 */
	void update( INetworkCall call );
	
	/**
	 * Removes all the calls that are collected by this list
	 */
	void clear();
	
	/**
	 * This register the INetworkMonitor to receive notifications of changes to calls and
	 * the call list.
	 * 
	 * @param netMonitor
	 */
	void addListener( INetworkMonitor netMonitor );
	
	/**
	 * This unregister the INetworkMonitor
	 * 
	 * @param netMonitor
	 */
	void removeListener( INetworkMonitor netMonitor );
}
