package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHeader;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHeaderContainer;

/**
 * Basic implementaion of an IHeaderContainer. It saves the headers in a
 * HashMap.
 * 
 * @author Gino Bustelo
 *
 */
public abstract class BaseHeaderContainer implements IHeaderContainer {

	protected HashMap headers = new HashMap();
	
	
	protected class HeaderImpl implements IHeader{

		protected String name;
		protected String value;
		
		public HeaderImpl( String name, String value ){
			this.name = name;
			this.value = value;
		}
		
		public String getName() {
			return name;
		}

		public String getValue() {
			return value;
		}
		
	}
	
	public IHeader getHeader( String headerName ) {
		return (IHeader)headers.get( headerName );
	}

	public Iterator getHeaderNames() {
		return headers.keySet().iterator();
	}

	public void setHeader(String headerName, String headerValue) {
		IHeader header = new HeaderImpl( headerName, headerValue );
		headers.put( headerName, header );
	}

	public IHeader[] getHeaders() {
		
		Collection values = headers.values();
		IHeader[] headerArray = new IHeader[ values.size() ];
		
		return (IHeader[])values.toArray( headerArray ) ;
	}
	
	

}
