package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHTTPResponse;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.INetworkCall;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IRequest;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.IResponse;

abstract public class BaseNetworkCall implements INetworkCall {
	
	protected IHTTPRequest request;
	protected IHTTPResponse response;
	
	/*
	 * Timing information
	 */
	protected long startTime = -1L;
	protected long endTime = -1L;
	
	/*
	 * Can be ACTIVE, SUCCESS, WARNING, ERROR
	 */
	protected String state;
	
	
	public IRequest getRequest() {
		return request;
	}

	public IResponse getResponse() {
		return response;
	}
	
	public long getStartTime() {
		return startTime;
	}
	
	public long getEndTime() {
		return endTime;
	}	

	public int getTotalTime() {
		if( endTime == -1 || startTime == -1 )
			return -1;
		else
			return (int) (endTime - startTime);
	}
	
	public String getState() {
		return state;
	}

}
