package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import org.mozilla.interfaces.nsIHttpChannel;

/**
 * This class is used to capture the request side of an HTTP call from
 * the XPCOM representation of the call (nsIHttpChannel).
 * 
 * @author Gino Bustelo
 *
 */
public class MozHTTPCall extends BaseNetworkCall {
	
	public MozHTTPCall(){
		
	}
	
	/**
	 * This method is called to set the information about the request
	 * side of the HTTP call.
	 * 
	 * @param httpChannel nsIHTTPChannel representing the call on the XPCOM side
	 */
	public void captureRequest( nsIHttpChannel httpChannel ){
		startTime = System.currentTimeMillis();
		state = ACTIVE_STATE;
		
		request = createRequest( httpChannel );
	}
	
	protected MozHTTPRequest createRequest( nsIHttpChannel httpChannel ){
		return new MozHTTPRequest( httpChannel );
	}
	
	/**
	 * This method is called to set the information about the response
	 * side of the HTTP call.
	 * 
	 * @param httpChannel nsIHTTPChannel representing the call on the XPCOM side
	 */
	public void captureResponse( nsIHttpChannel httpChannel ){
		
		endTime = System.currentTimeMillis();
		
		try{
			response = createResponse( httpChannel );
			
			if( httpChannel.getResponseStatus() == 200 ) {
				state = SUCCESS_STATE;
			} else {
				state = WARNING_STATE;
			}
		}
		catch( Exception e ){
			state = ERROR_STATE;
		}
	}
	
	protected MozHTTPResponse createResponse( nsIHttpChannel httpChannel ){
		return new MozHTTPResponse( httpChannel, this ); 
	}

}
