package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import org.eclipse.atf.mozilla.ide.ui.netmon.model.IHTTPRequest;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIHttpHeaderVisitor;
import org.mozilla.interfaces.nsIInputStream;
import org.mozilla.interfaces.nsIScriptableInputStream;
import org.mozilla.interfaces.nsISeekableStream;
import org.mozilla.interfaces.nsIUploadChannel;
import org.mozilla.xpcom.Mozilla;

/**
 * This class is used to extract the HTTPCall request side information from the
 * XPCOM couterpart.
 * 
 * @author Gino Bustelo
 *
 */
public class MozHTTPRequest extends MozHeaderContainer implements IHTTPRequest {

	//URL of the http request
	protected String url;
	
	//HTTP method value
	protected String method;
	
	//Body content of the request
	protected String body = "";
	
	//marks if this request is started using XHR
	protected boolean xhr = false;
	
	public MozHTTPRequest( nsIHttpChannel httpChannel ){
		this( httpChannel, false );
	}
	
	public MozHTTPRequest( nsIHttpChannel httpChannel, boolean xhr ){
		//creating the local request representation
		
		this.xhr = xhr;
		
		//URL of the request
		this.url = httpChannel.getURI().getAsciiSpec();
		
		//HTTP method used
		this.method = httpChannel.getRequestMethod();

		extractBody(httpChannel);
		
		extractHeaders(httpChannel);
	}
	
	/*
	 * Currently handling POSTs and GETs
	 */
	protected void extractBody( nsIHttpChannel httpChannel ) {
		if ( GET_METHOD.equals(this.method) ) {
			// set the body to the parameters in the URL
			body = httpChannel.getURI().getPath();

		} else if ( POST_METHOD.equals(this.method) ) {
			// set the POST body as the body
			
			//The POST body needs to be read from an InputStream
			nsIScriptableInputStream scriptableIS = null;
			
			//need it so that we can rewind the stream back
			nsISeekableStream seekableStream = null;
			nsIInputStream is = null;
			try {
				nsIUploadChannel upChannel = (nsIUploadChannel) httpChannel
						.queryInterface(nsIUploadChannel.NS_IUPLOADCHANNEL_IID);

				is = upChannel.getUploadStream();
				if (is != null) {
					seekableStream= (nsISeekableStream) is.queryInterface(nsISeekableStream.NS_ISEEKABLESTREAM_IID);

					scriptableIS = (nsIScriptableInputStream) Mozilla
							.getInstance()
							.getComponentManager()
							.createInstanceByContractID(
									"@mozilla.org/scriptableinputstream;1",
									null,
									nsIScriptableInputStream.NS_ISCRIPTABLEINPUTSTREAM_IID);

					scriptableIS.init(is);
					
					//read the entire stream into a StringBuffer
					StringBuffer postBuf = new StringBuffer();
					long count;
					while(  (count = scriptableIS.available()) > 0 )//some left to read{
						postBuf.append( scriptableIS.read(count) );
					
					
					body = postBuf.toString();
						
				}
			} catch (Exception e) {
				//Any errors here, the POST body will be empty
			}
			finally{
				if( scriptableIS != null )
					scriptableIS.close();
				
				//rewind
				if( seekableStream != null ){
					seekableStream.seek( 0, 0 );
				}
				
				if( is != null )
					is.close();
			}
		}
	}
	
	public String getBody() {
		return body;
	}

	public String getMethod() {
		return method;
	}

	public String getURL() {
		return url;
	}

	public boolean isXHR() {
		return xhr;
	}

	protected void visitHeaders(nsIHttpChannel httpChannel,
			nsIHttpHeaderVisitor visitor) {
		httpChannel.visitRequestHeaders( visitor );		
	}
}
