package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIHttpHeaderVisitor;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;

abstract public class MozHeaderContainer extends BaseHeaderContainer {

	protected void extractHeaders( nsIHttpChannel httpChannel ) {
		//populate the headers
		visitHeaders( httpChannel, new nsIHttpHeaderVisitor() {

			public void visitHeader(String headerName, String headerValue) {
				setHeader(headerName, headerValue);
			}

			public nsISupports queryInterface(String id) {
				return Mozilla.queryInterface(this, id);
			}

		});
	}
	
	abstract protected void visitHeaders( nsIHttpChannel httpChannel, nsIHttpHeaderVisitor visitor );
}
